#ifndef CE2_RSA_ERROR_H
#define CE2_RSA_ERROR_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_error.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Mon Mar 05 15:25:50 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains contains error codes for RSA functions.
* 
* \version CE2_RSA_Error.h#1:csrc:1
* \author Pavel Sasunkevich
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/* Simple macro for check error:
if error appears then goto exit_label. */
#define IF_ERROR_GOTO_EXIT_LABEL(error_code) \
	if (error_code != CRYPT_OK)\
	{\
		error_code = LLF_RSA_MODULE_ERROR_BASE;\
		goto exit_label;\
	}

/* Simple macro for check error:
if new error appears then set error and goto exit_label. */
#define IF_NEW_ERROR_GOTO_EXIT_LABEL(error_code,new_error) \
	if (new_error != CRYPT_OK)\
	{\
		error_code = new_error;\
		goto exit_label;\
	}

/* Simple macro for check error:
if boolean_expression == true then
error appears and then goto exit_label. */
#define IF_TRUE_GOTO_EXIT_LABEL(boolean_expression) \
	if (boolean_expression)\
	{\
		error_code = LLF_RSA_MODULE_ERROR_BASE;\
		goto exit_label;\
	}

/* Simple macro for check error:
if boolean_expression == true then
error appears and then set error and goto exit_label. */
#define IF_TRUE_GOTO_EXIT_LABEL_SET_NEW_ERROR(boolean_expression,new_error) \
	if (boolean_expression)\
	{\
		error_code = new_error;\
		goto exit_label;\
	}

/* defines for RSA cryptography */
/* PKI RSA module on the LLF layer base address - 0x00F10400 */
#define LLF_RSA_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
                                   (CE2_ERROR_LAYER_RANGE * LLF_LAYER_ERROR_IDX) + \
                                   (CE2_ERROR_MODULE_RANGE * RSA_ERROR_IDX ) )

/* CE2_RSA() error codes */
/* CE2_RSA_BUILD() error codes */
#define CE2_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR	(CE2_RSA_MODULE_ERROR_BASE + 1)
#define CE2_RSA_INVALID_EXPONENT_POINTER_ERROR			(CE2_RSA_MODULE_ERROR_BASE + 2)
#define CE2_RSA_BUILD_INVALID_MODULUS_PTR_ERROR			(CE2_RSA_MODULE_ERROR_BASE + 3)
#define CE2_RSA_INVALID_MODULUS_SIZE					(CE2_RSA_MODULE_ERROR_BASE + 4)
#define CE2_RSA_INVALID_EXPONENT_SIZE					(CE2_RSA_MODULE_ERROR_BASE + 5)

#define CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR	(CE2_RSA_MODULE_ERROR_BASE + 6)
#define CE2_RSA_BUILD_INVALID_PRIV_EXPONENT_PTR_ERROR	(CE2_RSA_MODULE_ERROR_BASE + 7)
#define CE2_RSA_BUILD_INVALID_PUB_EXPONENT_PTR_ERROR	(CE2_RSA_MODULE_ERROR_BASE + 8)

#define CE2_RSA_BUILD_INVALID_P_PTR_ERROR				(CE2_RSA_MODULE_ERROR_BASE + 9)
#define CE2_RSA_BUILD_INVALID_Q_PTR_ERROR				(CE2_RSA_MODULE_ERROR_BASE + 10)
#define CE2_RSA_BUILD_INVALID_DP_PTR_ERROR				(CE2_RSA_MODULE_ERROR_BASE + 11)
#define CE2_RSA_BUILD_INVALID_DQ_PTR_ERROR				(CE2_RSA_MODULE_ERROR_BASE + 12)
#define CE2_RSA_BUILD_INVALID_QINV_PTR_ERROR			(CE2_RSA_MODULE_ERROR_BASE + 13)

#define CE2_RSA_BUILD_INVALID_MODULUS_SIZE_PTR_ERROR	(CE2_RSA_MODULE_ERROR_BASE + 14)

#define CE2_RSA_BUILD_INVALID_PRIV_EXPONENT_SIZE_PTR_ERROR	(CE2_RSA_MODULE_ERROR_BASE + 15)
#define CE2_RSA_BUILD_INVALID_PUB_EXPONENT_SIZE_PTR_ERROR	(CE2_RSA_MODULE_ERROR_BASE + 16)

#define CE2_RSA_BUILD_INVALID_QINV_SIZE_PTR_ERROR		(CE2_RSA_MODULE_ERROR_BASE + 17)

#define CE2_RSA_PUB_KEY_VALIDATION_TAG_ERROR			(CE2_RSA_MODULE_ERROR_BASE + 18)
#define CE2_RSA_PRIM_DATA_STRUCT_POINTER_INVALID		(CE2_RSA_MODULE_ERROR_BASE + 19)
#define CE2_RSA_DATA_POINTER_INVALID_ERROR				(CE2_RSA_MODULE_ERROR_BASE + 20)
#define CE2_RSA_INVALID_OUTPUT_POINTER_ERROR			(CE2_RSA_MODULE_ERROR_BASE + 21)
#define CE2_RSA_INVALID_MESSAGE_BUFFER_SIZE				(CE2_RSA_MODULE_ERROR_BASE + 22)
#define CE2_RSA_INVALID_MESSAGE_DATA_SIZE				(CE2_RSA_MODULE_ERROR_BASE + 23)
#define CE2_RSA_INVALID_MESSAGE_VAL						(CE2_RSA_MODULE_ERROR_BASE + 24)

#define CE2_RSA_PRIV_KEY_VALIDATION_TAG_ERROR			(CE2_RSA_MODULE_ERROR_BASE + 25)

#define CE2_BAD_PARAM									(CE2_RSA_MODULE_ERROR_BASE + 26)
#define CE2_OUT_OF_RANGE								(CE2_RSA_MODULE_ERROR_BASE + 27)

#define CE2_RSA_HASH_ILLEGAL_OPERATION_MODE_ERROR		(CE2_RSA_MODULE_ERROR_BASE + 28)
#define CE2_RSA_MGF_ILLEGAL_ARG_ERROR					(CE2_RSA_MODULE_ERROR_BASE + 29)
#define CE2_RSA_PKCS1_VER_ARG_ERROR						(CE2_RSA_MODULE_ERROR_BASE + 30)
#define CE2_INVALID_SIGNATURE							(CE2_RSA_MODULE_ERROR_BASE + 31)

/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

#ifdef __cplusplus
}
#endif

#endif /* CE2_RSA_ERROR_H */
